<?php

namespace App\Modules\Legal\Migrations\AgainstCompanyLawsuitSession;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AgainstCompanyLawsuitSession extends Model 
{

    protected $table = 'legal_against_company_lawsuit_sessions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function againstCompanyLawsuit()
    {
        return $this->belongsTo('AgainstCompanyLawsuits', 'against_company_lawsuit_id');
    }

}